// Language translations
const translations = {
    'en': {
        'warning': 'WARNING!<br> YOU WILL SEE NAKED PICTURES HERE',
        'ok': 'OK',
        'empty': ''
    },
    'pt': {
        'warning': 'AVISO!<br> VOCÊ VAI VER FOTOS NUAS AQUI',
        'ok': 'OK',
        'empty': ''
    },
    'cs': {
        'warning': 'UPOZORNĚNÍ!<br> UVIDÍTE ZDE NAHÉ OBRAZY',
        'ok': 'OK',
        'empty': ''
    },
    'pl': {
        'warning': 'OSTRZEŻENIE!<br> ZOBACZYSZ TUTAJ NAJĘTE ZDJĘCIA',
        'ok': 'OK',
        'empty': ''
    },
    'fr': {
        'warning': 'AVERTISSEMENT!<br> VOUS VEREZ DES PHOTOS NUES ICI',
        'ok': 'OK',
        'empty': ''
    },
    'ru': {
        'warning': 'ПРЕДУПРЕЖДЕНИЕ!<br> ВЫ УВИДИТЕ ГОЛЫЕ ФОТОГРАФИИ ЗДЕСЬ',
        'ok': 'ОК',
        'empty': ''
    },
    'es': {
        'warning': '¡ADVERTENCIA!<br> AQUÍ VERÁS FOTOS DESNUDAS',
        'ok': 'OK',
        'empty': ''
    },
    'it': {
        'warning': 'ATTENZIONE!<br> VEDRAI FOTO IN NUDO QUI',
        'ok': 'OK',
        'empty': ''
    },
    'uk': {
        'warning': 'УВАГА!<br> ВИ БУДЕТЕ БАЧИТИ ГОЛІ ФОТОГРАФІЇ ТУТ',
        'ok': 'ОК',
        'empty': ''
    },
    'de': {
        'warning': 'WARNUNG!<br> SIE WERDEN HIER NACKTBILDER SEHEN',
        'ok': 'OK',
        'empty': ''
    },
    'nl': {
        'warning': 'WAARSCHUWING!<br> JE ZULT HIER NAAKT FOTO\'S ZIEN',
        'ok': 'OK',
        'empty': ''
    },
    'zh': {
        'warning': '警告！<br> 你将看到裸体照片',
        'ok': '确定',
        'empty': ''
    },
    'ar': {
        'warning': 'تحذير!<br> ستشاهد صور عارية هنا',
        'ok': 'موافق',
        'empty': ''
    },
    'fa': {
        'warning': 'هشدار!<br> شما در اینجا تصاویر برهنه خواهید دید',
        'ok': 'باشه',
        'empty': ''
    },
    'tr': {
        'warning': 'UYARI!<br> BURADA ÇIPLAK RESİMLER GÖRECEKSİNİZ',
        'ok': 'Tamam',
        'empty': ''
    },
    'ro': {
        'warning': 'ATENȚIE!<br> VEI VEDEA IMAGINI GOALE AICI',
        'ok': 'OK',
        'empty': ''
    },
    'hr': {
        'warning': 'UPOZORENJE!<br> OVDE ĆETE VIDETI GOLE SLIKE',
        'ok': 'U REDU',
        'empty': ''
    },
    'bg': {
        'warning': 'ВНИМАНИЕ!<br> ЩЕ ВИДИТЕ ГОЛИ СНИМКИ ТУК',
        'ok': 'ОК',
        'empty': ''
    },
    'hu': {
        'warning': 'FIGYELEM!<br> MEZTELEN KÉPEKET LÁT ITT',
        'ok': 'OK',
        'empty': ''
    },
    'sv': {
        'warning': 'VARNING!<br> DU KOMMER ATT SE NAKNA BILDER HÄR',
        'ok': 'OK',
        'empty': ''
    },
    'no': {
        'warning': 'ADVARSEL!<br> DU VIL SE NAKNE BILDER HER',
        'ok': 'OK',
        'empty': ''
    },
    'fi': {
        'warning': 'VAROITUS!<br> NÄET ALASTOMIA KUVI A TÄÄLLÄ',
        'ok': 'OK',
        'empty': ''
    },
    'ko': {
        'warning': '경고!<br> 여기에 나체 사진이 표시됩니다',
        'ok': '확인',
        'empty': ''
    },
    'da': {
        'warning': 'ADVARSEL!<br> DU VIL SE NØGEN BILLEDER HER',
        'ok': 'OK',
        'empty': ''
    },
    'ja': {
        'warning': '警告!<br> ここでヌード写真が見られます',
        'ok': 'OK',
        'empty': ''
    },
    'hi': {
        'warning': 'चेतावनी!<br> आप यहां नग्न तस्वीरें देखेंगे',
        'ok': 'ठीक है',
        'empty': ''
    },
    'bn': {
        'warning': 'সতর্কতা!<br> আপনি এখানে নগ্ন ছবি দেখতে পাবেন',
        'ok': 'ওকে',
        'empty': ''
    },
    'sk': {
        'warning': 'UPOZORNENIE!<br> TU UVIDÍTE HOLÉ OBRAZY',
        'ok': 'OK',
        'empty': ''
    },
    'sl': {
        'warning': 'OPOZORILO!<br> TU BOSTE VIDELI GOLE SLIKE',
        'ok': 'OK',
        'empty': ''
    },
    'id': {
        'warning': 'PERINGATAN!<br> ANDA AKAN MELIHAT FOTO TELANJANG DI SINI',
        'ok': 'OK',
        'empty': ''
    }
};

// Function to detect browser language
function getBrowserLanguage() {
    const lang = navigator.language || navigator.userLanguage;
    return lang.split('-')[0]; // Returns 'en', 'pt', 'cs', etc.
}

// Function to apply translations
function applyTranslations(lang) {
    const elements = document.querySelectorAll('[data-translate]');
    elements.forEach(el => {
        const key = el.getAttribute('data-translate');
        if (translations[lang] && translations[lang][key]) {
            el.innerHTML = translations[lang][key];
        }
    });
}

// Initialize translations
document.addEventListener('DOMContentLoaded', () => {
    const lang = getBrowserLanguage() in translations ? getBrowserLanguage() : 'en';
    applyTranslations(lang);
});